/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigManager {
    private String serverIp;
    private int serverPort;

    public ConfigManager() {
        this.loadConfig();
    }

    private void loadConfig() {
        Properties prop = new Properties();
        File file = new File("config.properties");
        try (FileInputStream input = new FileInputStream(file);){
            prop.load(input);
            this.serverIp = prop.getProperty("server.ip", "192.168.10.228");
            this.serverPort = Integer.parseInt(prop.getProperty("server.port", "4444"));
        }
        catch (FileNotFoundException e) {
            this.createDefaultConfig(file);
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
            this.serverIp = "192.168.10.228";
            this.serverPort = 4444;
        }
    }

    private void createDefaultConfig(File file) {
        System.err.println("\u0424\u0430\u0439\u043b config.properties \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0421\u043e\u0437\u0434\u0430\u0451\u043c \u0444\u0430\u0439\u043b \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e...");
        Properties prop = new Properties();
        prop.setProperty("server.ip", "192.168.10.228");
        prop.setProperty("server.port", "4444");
        try (FileOutputStream output = new FileOutputStream(file);){
            prop.store(output, "\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            System.out.println("\u0424\u0430\u0439\u043b config.properties \u0441\u043e\u0437\u0434\u0430\u043d \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e.");
        }
        catch (IOException ex) {
            System.err.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!");
            ex.printStackTrace();
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

