/*
 * Decompiled with CFR 0.152.
 */
package org.scorpion;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Updater {
    private static final String REMOTE_APP_URL = "https://public.mirror-all.ru/updater/client_socket.jar";
    private static final String LOCAL_APP_FILENAME = "client_socket.jar";
    private static final int MAX_RETRY_COUNT = 5;
    private static final int RETRY_DELAY_MS = 30000;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(() -> Updater.checkForUpdates()).start();
    }

    private static void checkForUpdates() {
        try {
            String userHome = System.getProperty("user.home");
            Path targetDir = Paths.get(userHome, "updater_launch");
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                System.out.println("\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u043f\u0430\u043f\u043a\u0430: " + targetDir.toAbsolutePath());
            }
            Path localAppPath = targetDir.resolve(LOCAL_APP_FILENAME);
            Path localVersionPath = targetDir.resolve("version.txt");
            String remoteVersion = null;
            int retryCount = 0;
            while (retryCount < 5 && remoteVersion == null) {
                try {
                    remoteVersion = Updater.getRemoteVersion("https://public.mirror-all.ru/updater/client_socket.jar.version");
                }
                catch (IOException e) {
                    if (++retryCount == 1) {
                        Updater.showRetryDialog(retryCount, 5);
                    }
                    if (retryCount < 5) {
                        System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0442\u0438. \u041f\u043e\u0432\u0442\u043e\u0440 \u0447\u0435\u0440\u0435\u0437 30 \u0441\u0435\u043a\u0443\u043d\u0434...");
                        Thread.sleep(30000L);
                        continue;
                    }
                    System.out.println("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432 \u0444\u043e\u043d\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c.");
                    Updater.scheduleBackgroundUpdate(targetDir, localAppPath, localVersionPath);
                    return;
                }
            }
            String localVersion = Updater.getLocalVersion(localVersionPath.toString());
            if (!remoteVersion.equals(localVersion) || !Files.exists(localAppPath, new LinkOption[0])) {
                System.out.println("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f: " + remoteVersion);
                Updater.downloadFile(REMOTE_APP_URL, localAppPath.toString());
                Updater.writeVersionToFile(remoteVersion, localVersionPath.toString());
                JOptionPane.showMessageDialog(null, "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e!", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 1);
            } else {
                System.out.println("\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u0430.");
            }
            Updater.launchApp(localAppPath.toString());
        }
        catch (Exception e) {
            System.err.println("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430:");
            e.printStackTrace();
        }
    }

    private static void scheduleBackgroundUpdate(Path targetDir, final Path localAppPath, final Path localVersionPath) {
        final Timer timer = new Timer();
        final AtomicInteger attempt = new AtomicInteger(0);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                block3: {
                    try {
                        String remoteVersion = Updater.getRemoteVersion("https://public.mirror-all.ru/updater/client_socket.jar.version");
                        String localVersion = Updater.getLocalVersion(localVersionPath.toString());
                        if (!remoteVersion.equals(localVersion) || !Files.exists(localAppPath, new LinkOption[0])) {
                            System.out.println("\u0424\u043e\u043d\u043e\u0432\u0430\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f...");
                            Updater.downloadFile(Updater.REMOTE_APP_URL, localAppPath.toString());
                            Updater.writeVersionToFile(remoteVersion, localVersionPath.toString());
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e \u0432 \u0444\u043e\u043d\u043e\u0432\u043e\u043c \u0440\u0435\u0436\u0438\u043c\u0435.", "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e", 1));
                        }
                        timer.cancel();
                        System.exit(0);
                    }
                    catch (Exception e) {
                        int currentAttempt = attempt.incrementAndGet();
                        if (currentAttempt < 5) break block3;
                        System.out.println("\u0424\u043e\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u043e \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043e\u043a.");
                        timer.cancel();
                        System.exit(1);
                    }
                }
            }
        }, 30000L, 30000L);
    }

    private static void showRetryDialog(int attempt, int maxAttempts) {
        String message = String.format("\u041d\u0435\u0442 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443. \u041f\u043e\u0432\u0442\u043e\u0440 \u0447\u0435\u0440\u0435\u0437 30 \u0441\u0435\u043a\u0443\u043d\u0434... (%d/%d)", attempt, maxAttempts);
        JOptionPane.showMessageDialog(null, message, "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443", 2);
    }

    private static String getRemoteVersion(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String version = reader.readLine().trim();
        reader.close();
        return version;
    }

    private static String getLocalVersion(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            return "0";
        }
        Scanner scanner = new Scanner(file);
        String version = scanner.hasNextLine() ? scanner.nextLine().trim() : "0";
        scanner.close();
        return version;
    }

    private static void writeVersionToFile(String version, String path) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(path));
        writer.write(version);
        writer.close();
    }

    private static void downloadFile(String fileUrl, String targetPath) throws IOException {
        System.out.println("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0444\u0430\u0439\u043b\u0430: " + fileUrl + " -> " + targetPath);
        URL url = new URL(fileUrl);
        InputStream in = url.openStream();
        Files.copy(in, Paths.get(targetPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        in.close();
    }

    private static void launchApp(String appPath) throws IOException {
        ProcessBuilder pb;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            pb = new ProcessBuilder("javaw", "-jar", appPath);
        } else if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            pb = new ProcessBuilder("java", "-jar", appPath);
        } else {
            throw new RuntimeException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430!");
        }
        pb.start();
        System.out.println("\u0417\u0430\u043f\u0443\u0449\u0435\u043d\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435: " + appPath);
    }
}

